#!/bin/sh

sox A.mp3 -r 8000 -c 1 -w -s A.raw
dd if=A.raw of=Ac.bin bs=16000 skip=200 

NAME=Ac

FREQS="1102.966 1272.888"
WGTS="-1 1"
OFFS=0

demod ${NAME}.bin 8000 20 ${FREQS} >${NAME}.dem
discrim $WGTS <${NAME}.dem >${NAME}.dis
decode 8 $OFFS <${NAME}.dis >${NAME}.dec
awk '(NR > 1769){print}' ${NAME}.dec >${NAME}.dec2
extract_pll 100 <${NAME}.dec2 >${NAME}.txt
awk '(NR > 1 && NR < 590){print}' ${NAME}.txt >${NAME}.txt2
time quick_setting key0.txt ${NAME}.txt2 |tee setting.out
tail -13 setting.out >key.txt
cryptrace key.txt ${NAME}.txt2 >${NAME}.trace

